<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Point extends Model 
{

    protected $table = 'points';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'booking_id', 'amount');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function booking()
    {
        return $this->belongsTo('App\Models\Booking');
    }

    public function wallets()
    {
        return $this->hasMany('App\Models\Wallet');
    }

}